function d = datboq(d)
% datboq  Beginning of quarter for the specified daily date.
%
% Syntax
% =======
%
%     BOQ = datboq(D)
%
% Input arguments
% ================
%
% * `D` [ numeric ] - Daily serial date number.
%
% Output arguments
% =================
%
% * `BOQ` [ numeric ] - Daily serial date number for the first day of the
% same quarter as `D`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[y,m] = datevec(d);
m = ceil(m/3);
d = datenum([y,m,1]);

end