function d = datbom(d)
% datbom  Beginning of month for the specified daily date.
%
% Syntax
% =======
%
%     BOM = datebom(D)
%
% Input arguments
% ================
%
% * `D` [ numeric ] - Daily serial date number.
%
% Output arguments
% =================
% * `BOM` [ numeric ] - Daily serial date number for the first day of the
% same month as `D`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[y,m] = datevec(d);
d = datenum([y,m,1]);

end