function dat = bbtoday()
% bbtoday  IRIS serial date number for current bi-month.
%
% Syntax
% =======
%
%     d = bbtoday()
%
% Output arguments
% =================
%
% * `d` [ numeric ]  - IRIS serial date number for current bi-month.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[year,month] = datevec(now());
dat = bb(year,1+floor((month-1)/2));

end