function timeline(h,time,userrange,freq,opt)
% TIMELINE  [Not a public function] Set up x-axis for tseries object graphs.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if isequalwithequalnans(time,NaN)
    return
end

% Determine x-limits first.
first = userrange(1);
last = userrange(end);
if isinf(first)
    if freq > 0
        % Lower limit if user entered Inf: First period in first plotted
        % year.
        first = datcode(freq,floor(time(1)),1);
    else
        first = time(1);
    end
end
if isinf(last)
    if freq > 0
        % Upper limit if user entered Inf: Last period in last plotted
        % year.
        last = datcode(freq,floor(time(end)),freq);
    else
        last = time(end);
    end
end
xlim = [first,last];
if freq > 0
    xlim = dat2grid(xlim,opt.dateposition);
end
set(h,'xLim',xlim,'xLimMode','manual');

xTick = [];
if freq == 0
    do_zerofreq();
else
    do_normalfreq();
end

%**************************************************************************
    function do_normalfreq()
        if isequal(opt.datetick,Inf)
            % Determine step and xTick.
            % Step is number of periods.
            % If multiple axes handles are passed in (e.g. plotyy) use just
            % the first one to get xTick but set the properties for both
            % eventually.
            xTick = get(h(1),'xTick');
            if length(xTick) > 1
                step = round(freq*(xTick(2) - xTick(1)));
            else
                step = 1;
            end
            if step < 1
                step = 1;
            end
            if step < freq
                % Make sure freq/step is integer.
                if rem(freq,step) > 0
                    step = freq / floor(freq/step);
                end
            elseif step > freq
                % Make sure step/freq is integer.
                if rem(step,freq) > 0
                    step = freq * floor(step/freq);
                end
            end
            nstep = round(freq/step*(xlim(2) - xlim(1)));
            xTick = xlim(1) + step/freq*(0 : nstep);
        elseif isnumeric(opt.datetick)
            xTick = dat2grid(opt.datetick,opt.dateposition);
        elseif ischar(opt.datetick)
            switch lower(opt.datetick)
                case 'yearstart'
                    temprange = first : last;
                    [ans,tempper] = dat2ypf(temprange); %#ok<NOANS,ASGLU>
                    xTick = dat2grid( ...
                        temprange(tempper == 1), ...
                        opt.dateposition);
                case 'yearend'
                    temprange = first : last;
                    [ans,tempper] = dat2ypf(temprange); %#ok<NOANS,ASGLU>
                    xTick = dat2grid( ...
                        temprange(tempper == freq), ...
                        opt.dateposition);
                case 'yearly'
                    xTick = dat2grid( ...
                        first : freq : last, ...
                        opt.dateposition);
            end
        end
        dosetxtick();
    end
% do_normalfreq().

%**************************************************************************
    function do_zerofreq()
        % Make sure the xTick step is not smaller than 1.
        if isinf(opt.datetick)
            xTick = get(h(1),'xTick');
            if any(diff(xTick) < 1)
                xTick = xTick(1) : xTick(end);
                set(h, ...
                    'xTick',xTick', ...
                    'xTickMode','manual');
            end
        else
            set(h,...
                'xTick',opt.datetick,...
                'xTickMode','manual');
        end
        if strncmp(opt.dateformat,'$',1)
            dosetxtick();
        end
    end
% do_zerofreq().

%**************************************************************************
    function dosetxtick()
        set(h, ...
            'xTick',xTick, ...
            'xTickMode','manual');
        % Set xTickLabel.
        opt = datdefaults(opt,true);
        xTickLabel = ...
            dat2str(grid2dat(xTick,freq,opt.dateposition),opt);
        set(h, ...
            'xTickLabel',xTickLabel, ...
            'xTickLabelMode','manual');
    end
% dosetxticklabel().

end

