function [x,range] = subsref(x,s)
% subsref  Subscripted reference function for tseries objects.
%
% Syntax returning numeric array
% ===============================
%
%     ... = x(dates)
%     ... = x(dates,...)
%
% Syntax returning tseries object
% ================================
%
%     ... = x{dates}
%     ... = x{dates,...}
%
% Input arguments
% ================
%
% * `x` [ tseries ] - Tseries object.
%
% * `dates` [ numeric ] - Dates for which the time series observations will
% be returned, either as a numeric array or as another tseries object.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright 2007-2012 Jaromir Benes.

%**************************************************************************

% Run `lagorlead` to tell if the first reference is a lag/lead. If yes,
% the startdate of `x` will be adjusted withing `lagorlead`.
[x,s] = lagorlead(x,s);
if isempty(s)
    return
end

switch s(1).type
    case '()'
        % Return a tseries object.
        [x,range] = mygetdata(x,s(1).subs{:});
    case '{}'
        % Return an array.
        [ans,range,x] = mygetdata(x,s(1).subs{:}); %#ok<NOANS,ASGLU>
        x = mytrim(x);
        if length(s) > 1
            x = subsref(x,s(2:end));
        end
    otherwise
        % Give standard access to public properties.
        x = builtin('subsref',x,s);
end

end