function [x,xmean,xstd] = stdise(x,flag)
% stdise  Standardise tseries data by subtracting mean and dividing by std deviation.
%
% Syntax
% =======
%
%     [X,M,S] = stdise(X)
%     [X,M,S] = stdise(X,FLAG)
%
% Input arguments
% ================
%
% * `X` [ tseries ] - Input tseries object whose data will be normalised.
%
% * `FLAG` [ 0 | 1 ] - `flag==0` normalises by N-1, `flag==1`
% normalises by `N`, where `N` is the sample length.
%
% Output arguments
% =================
%
% * `X` [ tseries ] - Output tseries object with standardised data.
%
% * `XMEAN` [ numeric ] - Estimated mean subtracted from the input tseries
% observations.
%
% * `XSTD` [ numeric ] - Estimated std deviation by which the input tseries
% observations have been divided.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 2
   flag = 0;
end

IP = inputParser();
IP.addRequired('X',@istseries);
IP.addRequired('FLAG',@(x) isequal(x,0) || isequal(x,1) );
IP.parse(x,flag);

%**************************************************************************

[x.data,xmean,xstd] = tseries.mystdize(x.data,flag);

end
