function x = replace(x,data,start,comment)
% replace  [Not a public function] Safely replace tseries object properties.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

x.data = data;
if nargin > 2
    x.start = start;
end
if nargin > 3 && (iscell(comment) || ischar(comment))
    if iscell(comment)
        x.Comment = comment;
    elseif ischar(comment)
        tmpsize = size(x.data);
        x.Comment = cell([1,tmpsize(2:end)]);
        x.Comment(:) = {comment};
    end
else
    s = size(x.data);
    s(1) = 1;
    x.Comment = cell(s);
    x.Comment(:) = {''};
end
x = mytrim(x);

end
