function x = redate(x,olddate,newdate)
% redate  Change time dimension of a tseries object.
%
% Syntax
% =======
%
%     x = redate(x,oldDate,newDate)
%
% Input arguments
% ================
%
% * `x` [ tseries ] - Input tseries object.
%
% * `oldDate` [ numeric ] - Base date that will be converted to a new date.
%
% * `newDate` [ numeric ] - A new date to which the base date `oldDate`
% will be changed; `newDate` can need not be the same frequency as
% `oldDate`.
%
% Output arguments
% =================
%
% * `x` [ tseries ] - Output tseries object with identical data as the
% input tseries object, but with its time dimension changed.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

P = inputParser();
P.addRequired('x',@(x) isa(x,'tseries'));
P.addRequired('oldDate',@isnumericscalar);
P.addRequired('newDate',@isnumericscalar);
P.parse(x,olddate,newdate);

%**************************************************************************

xfreq = get(x,'freq');
oldfreq = datfreq(olddate);

if oldfreq ~= xfreq
   utils.error('tseries', ...
      'Time series frequency and base date frequency must match.');
end

shift = round(x.start - olddate);
x.start = newdate + shift;

end