function [aa,ll,rr,varargout] = plotcmp(varargin)
% plotcmp  Comparison graph for two time series.
%
% Syntax
% =======
%
%     [AA,LL,RR] = plotcmp(X,...)
%     [AA,LL,RR] = plotcmp(RANGE,X,...)
%
% Input arguments
% ================
%
% * `RANGE` [ numeric ] - Date range; if not specified the entire range of
% the input tseries object will be plotted.
%
% * `X` [ tseries ] - Tseries object with two columns; the difference
% between the second and the first column will be displayed as an area or
% bar graph.
%
% Output arguments
% =================
%
% * `AA` [ numeric ] - Handles to the LHS and RHS axes.
%
% * `LL` [ numeric ] - Handles to the two original lines.
%
% * `RR` [ numeric ] - Handles to the area or bar difference graph.
%
% Options
% ========
%
% * `'diffColor='` [ numeric | *[1,0.75,0.75]* ] - Color that will be used
% to plot the area or bar difference graph.
%
% * `'diffPlotFunc='` [ @area | *@bar* ] - Function that will be used to
% plot the difference data on the RHS.
%
% See help on [`tseries/plotyy`](tseries/plotyy) for other options available.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if isnumeric(varargin{1})
   range = varargin{1};
   varargin(1) = [];
else
   range = Inf;
end

x = varargin{1};
varargin(1) = [];
x.data = x.data(:,:);
if size(x.data,2) ~= 2
   utils.error('tseries', ...
      'PLOTCMP only works with two-column tseries objects.');
end

[options,varargin] = passvalopt('tseries.plotcmp',varargin{:});

if ~isempty(options.rhsplotfunc)
    options.diffplotfunc = options.rhsplotfunc;
end

%**************************************************************************

d = tseries();
d.start = x.start;
d.data = x.data(:,2) - x.data(:,1);

[aa,ll,rr,varargout{1:nargout-3}] = ...
   plotyy(range,x,range,d,varargin{:},'rhsplotfunc',options.diffplotfunc);

set(rr,'faceColor',options.diffcolor,'edgeColor',options.diffcolor);

set(aa(1),'tag','plotcmpLhs');
set(aa(2),'tag','plotcmpRhs');

end