function x = normalise(x,normdate,varargin)
% normalise  Normalise data to particular date.
%
% Syntax
% =======
%
%     x = normalise(x)
%     x = normalise(x,normdate,...)
%
% Input arguments
% ================
%
% * `x` [ tseries ] -  Input tseries object that will be normalised.
%
% * `normdate` [ numeric | 'start' | 'end' | 'nanstart' | 'nanend' ] - Date
% relative to which the input data will be normalised; if not specified,
% 'nanstart' (the first date for which all columns have an observation)
% will be used.
%
% Output arguments
% =================
%
% * `x` [ tseries ] - Normalised tseries object.
%
% Options
% ========
%
% * `'mode='` [ 'add' | *'mult'* ]  - Additive or multiplicative
%     normalisation.
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

options = passvalopt('tseries.normalise',varargin{:});

if nargin == 1
    normdate = 'nanstart';
end

%**************************************************************************

if strncmpi(options.mode,'add',3)
    func = @minus;
else
    func = @rdivide;
end

if ischar(normdate)
    normdate = get(x,normdate);
end

tmpsize = size(x.data);
x.data = x.data(:,:);

y = mygetdata(x,normdate);
for i = 1 : size(x.data,2)
    x.data(:,i) = func(x.data(:,i),y(i));
end

if length(tmpsize) > 2
    x.data = reshape(x.data,tmpsize);
end

x = mytrim(x);

end
