function h = myjusterrorbars(x,y,low,high,relative,varargin)
% MYJUSTERRORBARS  [Not a public function] Add error bars to an existing plot.
%
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

realsmall = 0; %getrealsmall();

if size(x,1) == 1
    x = transpose(x);
end
[nper,nx] = size(x);

if size(y,1) == 1
    y = transpose(y);
end
ny = size(y,2);

if size(low,1) == 1
    low = transpose(low);
end
nlow = size(low,2);

if size(high,1) == 1
    high = transpose(high);
end
nhigh = size(high,2);

n = max(nx,ny);

xdata = nan(3*nper,n);
ydata = nan(3*nper,n);
for i = 1 : n
    if i <= nx
        xi = x(:,i);
    end
    if i <= ny
        yi = y(:,i);
    end
    if i <= nlow
        lowi = low(:,i);
    end
    if i <= nhigh
        highi = high(:,i);
    end
    if relative
        index = abs(lowi) <= realsmall & abs(highi) <= realsmall;
        lowi(index) = NaN;
        highi(index) = NaN;
    end
    tempxdata = [xi,xi,nan(size(xi))].';
    xdata(:,i) = tempxdata(:);
    if relative
        if all(lowi(:) >= 0 | isnan(lowi(:)))
            lowi = -lowi;
        end
        tempydata = [yi+lowi,yi+highi,nan(size(yi))].';
    else
        tempydata = [lowi,highi,nan(size(yi))];
    end
    ydata(:,i) = tempydata(:);
end

h = plot(xdata,ydata);
if ~isempty(varargin)
    set(h,varargin{:});
end
set(h,'marker','+','linestyle',':');

end