function [data,dates,x] = mygetdata(x,dates,varargin)
% MYGETDATA  [Not a public function] Get time series data for specific (discontinuous) dates.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% References to 2nd and higher dimensions.
if ~isempty(varargin)
    x.data = x.data(:,varargin{:});
    if nargout > 2
        x.Comment = x.Comment(1,varargin{:});
    end
end

% References to time dimension.
xsize = size(x.data);
x.data = x.data(:,:);
remove = true(1,xsize(1));
if isnumeric(dates) && ~isequal(dates,Inf)
    dates = dates(:);
    data = nan([length(dates),xsize(2:end)]);
    if ~isempty(x.data)
        index = round(dates - x.start + 1);
        test = index >= 1 ...
            & index <= xsize(1) ...
            & freqcmp(x.start,dates);
        data(test,:) = x.data(index(test),:);
        if nargout > 2
            remove(index(test)) = false;
        end
    end
elseif isequal(dates,Inf) || isequal(dates,':') || isequal(dates,'max')
    dates = x.start + (0 : xsize(1)-1);
    data = x.data;
    if nargout > 2
        remove(:) = false;
    end
elseif isequal(dates,'min')
    dates = x.start + (0 : xsize(1)-1);
    sample = all(~isnan(x.data),2);
    data = x.data(sample,:);
    if nargout > 2
        remove(sample) = false;
    end
else
    data = x.data([],:);
end

data = reshape(data,[size(data,1),xsize(2:end)]);

if nargout > 2
    if isreal(x.data)
        x.data(remove,:) = NaN;
    else
        x.data(remove,:) = NaN+1i*NaN;
    end
    x.data = reshape(x.data,[size(x.data,1),xsize(2:end)]);
end

end