function X = myexpsmooth(X,BETA,INIT)
% MYEXPSMOOTH  [Not a public function] Exponential smoothing.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

s = size(X);
X = X(:,:);
nx = size(X,2);

if isempty(INIT)
    INIT = nan(1,nx);
else
    INIT = INIT(:).';
    if length(INIT) < nx
        INIT(end+1:nx) = INIT(end);
    end
end

nper0 = NaN;
for i = 1 : nx
    data = X(:,i);    
    isnandata = isnan(data);
    first = find(~isnandata,1);
    last = find(~isnandata,1,'last');
    data = data(first:last);
    isinit = ~isnan(INIT(i));
    if isinit
        data = [INIT(i);data]; %#ok<AGROW>
    end
    nper = size(data,1);
    if nper ~= nper0
        w = toeplitz(BETA.^(0:nper-1));
        w = tril(w);
        w = bsxfun(@rdivide,w,sum(w,2));
    end
    data = w*data;
    if isinit
        data = data(2:end);
    end
    X(first:last,i) = data;
    nper0 = nper;
end

if length(s) > 2
    X = reshape(X,s);
end

end