function x = detrend(x,varargin)
% detrend  Remove a linear time trend.
%
% Syntax
% =======
%
%     x = detrend(x,range)
%
% Input arguments
% ================
%
% * `x` [ tseries ] - Input time series.
%
% * `range` [ tseries ] - Range for which the trend will be computed.
%
% Output arguments
% =================
%
% * `x` [ tseries ] - Output time series with a trend removed.
%
% Options
% ========
%
% See [`tseries/trend`](tseries/trend) for options available.
%
% Description
% ============
%
% Example
% ========
%
%}


% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

x = x - trend(x,varargin{:});

end