function varargout = barcon(varargin)
% barcon  Contribution bar graph for tseries objects.
%
% Syntax
% =======
%
%     [h,range] = barcon(x,...)
%     [h,range] = barcon(range,x,...)
%     [h,range] = barcon(a,range,x,...)
%
% Input arguments
% ================
%
% * `a` [ numeric ] - Handle to axes in which the graph will be plotted; if
% not specified, the current axes will used.
%
% * `range` [ numeric ] - Date range; if not specified the entire range of
% the input tseries object will be plotted.
%
% * `x` [ tseries ] - Input tseries object whose columns will be ploted as
% a contribution bar graph.
%
% Output arguments
% =================
%
% * `h` [ numeric ] - Handle(s) to the bars plotted.
%
% * `range` [ numeric ] - Actually plotted date range.
%
% Options
% ========
%
% * `'barWidth='` [ numeric | *0.8* ] - Width of bars as a percentage of the
% space each period occupies on the x-axis.
%
% * `'colorMap='` [ numeric | *get(gcf(),'colorMap')* ] - Color map used to
% fill the contribution bars.
%
% * `'dateFormat='` [ char | *irisget('plotdateformat')* ] - Date format for
% the tick marks on the x-axis.
%
% * `'dateTick='` [ numeric | *`Inf`* ] - Vector of dates locating tick marks
% on the x-axis; Inf means they will be created automatically.
%
% * `'evenlySpread='` [ *`true`* | `false` ] - Colors picked for the
% contribution bars are evenly spread across the color map.
%
% * `'ordering='` [ 'ascend' | 'descend' | *'preserve'* | numeric ] -
% Ordering of contributions with the same sign withinin each period;
% `'preserve'` means the original order will be preserved.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% AREA, BAR, BARCON, PLOT, PLOTYY, STEM

%**************************************************************************

[varargout{1:nargout}] = tseries.gplot('barcon',varargin{:});

end