function [C,R] = acf(x,dates,varargin)
% acf  Sample autocovariance and autocorrelation functions.
%
% Syntax
% =======
%
%     [C,R] = acf(X)
%     [C,R] = acf(X,DATES,...)
%
% Input arguments
% ================
%
% * `X` [ tseries ] - Tseries object.
%
% * `DATES` [ numeric | Inf ] - Dates or date range on which tseries data
% will be used.
%
% Output arguments
% =================
%
% * `C` [ numeric ] - Auto-/cross-covariance matrices.
%
% * `R` [ numeric ] - Auto-/cross-correlation matrices.
%
% Options
% ========
%
% * `'demean='` [ *`true`* | `false` ] - Remove mean from the data before
% computing the ACF.
%
% * `'order='` [ numeric | *`0`* ] - Order up to which the ACF will be
% computed.
%
% * `'smallSample='` [ *`true`* | `false` ] - Adjust degrees of freedom for
% small samples.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if ~exist('dates','var')
    dates = Inf;
end

options = passvalopt('tseries.acf',varargin{:});

%**************************************************************************

if isequal(dates,Inf)
    data = mygetdata(x,'min');
else
    data = mygetdata(x,dates);
end

if ndims(data) > 3
    data = data(:,:,:);
end

C = covfun.acovfsmp(data,options);
if nargout > 1
    % Convert covariances to correlations.
    R = covfun.cov2corr(C,'acf');
end

end
