classdef theparser
% theparser  [Not a public class] IRIS parser. 
%
% Backend IRIS class.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

    properties
        fname = '';
        code = '';
        caller = '';
        labels = cell(1,0);
        blkname = cell(1,0);
        altblkname = cell(0,2);
        altblknamewarn = cell(0,2);
        chkallbut = false(1,0);
        nameblk = false(1,0);
        eqtnblk = false(1,0);
        flagblk = false(1,0);
        flaggable = false(1,0);
        essential = false(1,0);
        otherkey = cell(1,0);
    end
    
    methods
        
        function THIS = theparser(varargin)
            if isempty(varargin)
                return
            end
            if length(varargin) == 1 && isa(varargin{1},'theparser')
                THIS = varargin{1};
                return
            end
            if length(varargin) == 1 && isa(varargin{1},'preparser')
                THIS.fname = varargin{1}.fname;
                THIS.code = varargin{1}.code;
                THIS.labels = varargin{1}.labels;
                return
            end
            if length(varargin) == 2 ...
                && ischar(varargin{1}) && isa(varargin{2},'preparser')
                THIS.fname = varargin{2}.fname;
                THIS.code = varargin{2}.code;
                THIS.labels = varargin{2}.labels;
                % Initialise class-specific theta parser.
                switch varargin{1}
                    case 'model'
                        THIS = model(THIS);
                    case 'syeq'
                        THIS = syeq(THIS);
                end
                return
            end
        end
        
        varargout = altsyntax(varargin)
        varargout = errorparsing(varargin)
        varargout = labelsback(varargin)
        varargout = parse(varargin)
        varargout = readblk(varargin)
    end
    
    methods (Access=protected)
        
        varargout = model(varargin)
        varargout = syeq(varargin)

    end

    methods (Static)
       
        varargout = parsenames(varargin)
        varargout = parseeqtns(varargin)
        varargout = parseflags(varargin)
        varargout = evaltimesubs(varargin)
        
    end
    
end