function [NAME,LABEL,VALUE,NAMEFLAG] = parsenames(BLK)
% parsenames [Not a public function] Parse names within a name block.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

patt = '(?<label>#\(\d+\))?\s*(?<name>[a-zA-Z]\w*)\s*(?<value>=[^;,\n]+[;,\n])?';
x = regexp(BLK,patt,'names');
NAME = {x(:).name};
LABEL = {x(:).label};
VALUE = {};
if nargout > 2
    VALUE = {x(:).value};
    VALUE = strrep(VALUE,'=','');
    VALUE = strrep(VALUE,'!','');
end
NAMEFLAG = false(size(NAME));

end