function [EQTN,EQTNLABEL,EQTNLHS,EQTNRHS,EQTNSIGN, ...
    SSTATELHS,SSTATERHS,SSTATESIGN] = parseeqtns(BLK)
% parseeqtns [Not a public function] Parse equations within an equation block.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

BLK = regexprep(BLK,'\s+','');
BLK = strrep(BLK,'!ttrend','ttrend');

pattern = [ ...
    '(?<label>#\(\d+\))?', ...
    '(?<eqtn>[^!;]+)', ...
    '(?<sstate>!![^!;]+)?;'];
[EQTN,tok] = regexp(BLK,pattern,'match','names');
EQTNLABEL = {tok(:).label};
eqtn = {tok(:).eqtn};
sstate = {tok(:).sstate};
sstate = strrep(sstate,'!!','');

[EQTNLHS,EQTNRHS,EQTNSIGN] = xxequalsign(eqtn);
[SSTATELHS,SSTATERHS,SSTATESIGN] = xxequalsign(sstate);

end

% Subfunctions.

%**************************************************************************
function [lhs,rhs,sign] = xxequalsign(list)
nlist = length(list);
lhs = strfun.emptycellstr(1,nlist);
rhs = strfun.emptycellstr(1,nlist);
sign = strfun.emptycellstr(1,nlist);
[start,finish] = regexp(list,'[:+]?=#?','once','start','end');
for i = 1 : nlist
    if ~isempty(start{i})
        lhs{i} = list{i}(1:start{i}-1);
        rhs{i} = list{i}(finish{i}+1:end);
        sign{i} = list{i}(start{i}:finish{i});
    else
        rhs{i} = list{i};
    end
end
end