function THIS = model(THIS)
% model [Not a public function] Initialise theta parser object for model class.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

THIS.caller = 'model';

THIS.blkname = {...
    '!measurement_variables', ...     1
    '!transition_variables', ...      2
    '', ...                           3 Used to be untyped shocks, not supported any more.
    '!parameters', ...                4
    '!log_variables', ...             5
    '!measurement_equations', ...     6
    '!transition_equations', ...      7
    '', ...                           8 Used to be substitutions, now expanded in preparser.
    '!dtrends', ...                   9
    '!reporting_equations', ...       10
    '!measurement_shocks', ...        11 Measurement shocks (type 1).
    '!transition_shocks', ...         12 Transition shocks (type 2).
    '!links', ...                     13 Dynamic links for parameters and/or steady-states.
    '!userdiff', ...                  14 List of user derivatives
    };

nblk = length(THIS.blkname);

THIS.nameblk = false(1,nblk);
THIS.nameblk([1,2,4,11,12]) = true;

THIS.eqtnblk = false(1,nblk);
THIS.eqtnblk([6,7,9,13]) = true;

THIS.flagblk = false(1,nblk);
THIS.flagblk(5) = true;

% Name blocks whose names can be referred to in flag blocks.
THIS.flaggable = false(1,nblk);
THIS.flaggable([1,2]) = true;

% Blocks that cannot remain empty.
THIS.essential = false(1,nblk);
THIS.essential([2,7]) = true;

THIS.altblkname = { ...
    '!equations','!transition_equations'; ...
    '!variables','!transition_variables'; ...
    '!shocks','!transition_shocks'; ...
    };

THIS.altblknamewarn = { ...
    '!coefficients','!parameters'; ...
    '!variables:residual','!shocks'; ...
    '!variables:innovation','!shocks'; ...
    '!residuals','!shocks'; ...
    '!outside','!equations:reporting'; ...
    '!equations:dtrends','!dtrends'; ...
    '!dtrends:measurement','!dtrends'; ...
    '!variables:transition','!transition_variables'; ...
    '!shocks:transition','!transition_shocks'; ...
    '!equations:transition','!transition_equations'; ...
    '!variables:measurement','!measurement_variables'; ...
    '!shocks:measurement','!measurement_shocks'; ...
    '!equations:measurement','!measurement_equations'; ...
    '!equations:reporting','!reporting_equations'; ...
    '!variables:log','!log_variables'; ...
    };

THIS.otherkey = { ...
    '!linear', ...
    '!ttrend', ...
    '!min', ...
    };

end