% PPCONVERTOUTP  [Not a public script] Create tseries objects for output data.

% OUTP = struct();
maxlag = -THIS.mint;
maxlead = THIS.maxt;
XRANGE = RANGE(1)-maxlag:RANGE(end)+maxlead;

% Create template tseries object.
template = tseries();
template.start = XRANGE(1);
template.Comment = cell(1,NLOOP);
template.Comment(:) = {''};

% TODO: Add descriptors as comments.

% Convert all output database fields to tseries objects.
list = fieldnames(OUTP);
for ii = 1 : length(list)
    name = list{ii};
    x = OUTP.(name);
    start = XRANGE(1);
    OUTP.(name) = template;
    index = any(~isnan(x(:,:)),2);
    % Trim leading and trailing all-NaN observations.
    if ~all(index)
        first = find(index,1,'first');
        last = find(index,1,'last');
        x = x(first:last,:);
        start = start + first - 1;
    end
    % If the tseries data are empty, set startdate to NaN.
    if isempty(x)
        start = NaN;
    end
    OUTP.(name).data = x;
    OUTP.(name).start = start;
end

% Add parameters.
for ii = find(THIS.nametype == 4)
    name = THIS.name{ii};
    OUTP.(name) = permute(THIS.Assign(1,ii,:),[1,3,2]);
end