function [THIS,NPATH,SSTATESUCCESS] = myupdatemodel(THIS,P,ASSIGNPOS,STDCORRPOS,OPT)
% MYUPDATEMODEL  [Not a public function] Update parameters and refresh.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

SSTATESUCCESS = true;
NPATH = 1;

assignNan = isnan(ASSIGNPOS);
ASSIGNPOS = ASSIGNPOS(~assignNan);
stdcorrNan = isnan(STDCORRPOS);
STDCORRPOS = STDCORRPOS(~stdcorrNan);

% Update regular parameters and run refresh if needed.
if any(~assignNan)
    THIS.Assign(1,ASSIGNPOS) = P(~assignNan);
end

% Update stds and corrs.
if any(~stdcorrNan)
    THIS.stdcorr(1,STDCORRPOS) = P(~stdcorrNan);
end

% Refresh dynamic links.
if nargin > 4 && OPT.refresh && ~isempty(THIS.Refresh)
    THIS = refresh(THIS);
end

end
