function this = mtimes(this,list)
% mtimes  Keep only the database entries that are on the list.
%
% Syntax
% =======
%
%     d = d * list
%
% Input arguments
% ================
%
% * `d` [ struct ] - Input database.
%
% * `list` [ cellstr ] - List of entries that will be kept in the output
% database.
%
% Output arguments
% =================
%
% * `d` [ struct ] - Output database with only the input entries kept that
% are on included in `list`.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.
    
    P = inputParser();
    P.addRequired('d',@isstruct);
    P.addRequired('list',@(x) iscellstr(x) || ischar(x));
    P.parse(this,list);
    
%**************************************************************************
    
    if ischar(list)
        list = regexp(list,'\w+','match');
    end
    
    f = fieldnames(this).';
    c = struct2cell(this).';
    [fnew,index] = intersect(f,list);
    this = cell2struct(c(index),fnew,2);
    
end
