function varargout = get(this,varargin)
% get  Query sstate object properties.
%
% Syntax
% =======
%
%     value = get(s,query)
%
% Input arguments
% ================
%
% * `s` [ sstate ] - Sstate object.
%
% * `query` [ char ] - Name of the queried property.
%
% Output arguments
% =================
%
% * `value` [ ... ] - Value of the queried property.
%
% Accessible sstate object properties
% ====================================
%
% * `'nblocks='` - Returns [ numeric ] the total number of equation blocks.
%
% * `'labels='` - Returns [ cellstr ] the list of block labels.
%
% Description
% ============
%

% -IRIS Toolbox.
% -Copyright 2007-2012 Jaromir Benes.

%**************************************************************************

[varargout{1:nargout}] = utils.get(this,varargin{:});

end
