function [x,flag] = specget(this,query)
% specget  [Not a public function] GET method for bkwmodel objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

[x,flag] = specget@metaobj(this,query);
if flag
   return
end

x = [];
flag = true;
query = lower(strtrim(query));
if length(query) > 1 && query(end) == 's'
   query(end) = '';
end

switch query
   
   case 'label'
      x = this.eqtnlabel;
      
   case {'required','initcond'}
      x = {};
      maxlag = size(this.occur,3) - 1;
      for t = 1 : maxlag
         index = any(this.occur(:,:,t+1),1);
         thisLagList = this.name(index);
         for i = 1 : length(thisLagList)
            x{end+1} = [thisLagList{i},sprintf('{-%g}',t)];
         end
      end
      
   case 'maxlag'
      x = size(this.occur,3) - 1;
      
   case 'canbeexogenised'
      x = this.name(this.nametype == 1);
      
   case 'canbeendogenised'
      x = this.name(this.nametype == 2 | this.nametype == 3);      
      
   otherwise
      flag = false;
      
end

end