function [THIS,SMOOTH,V,PRED,FILT] = filter(THIS,INPUT,RANGE,varargin)

opt = passvalopt('rhsmodel.kalman',varargin{:});
o = rhsmodel.optimset(opt);

% Get input data.
maxlag = size(THIS.occur,3) - 1;
if ~isinf(RANGE(1))
    xrange = [RANGE(1)-maxlag,RANGE(end)];
else
    xrange = RANGE;
end
[A,X,~,~,sy] = db2dp(THIS,INPUT,xrange);

[L,V,PE,A0,A1,A2] = kalman(THIS,A,X,sy,o,opt); %#ok<ASGLU>

% Output data.
X = X(:,:,1);
SMOOTH = dp2db(THIS,A2,X,xrange);
if nargout > 3
    PRED = dp2db(THIS,A0,X,xrange);
end
if nargout > 4
    FILT = dp2db(THIS,A1,X,xrange);
end

end