function c = saveas(P,FNAME)
% saveas  Save preparsed file.
%
% Syntax
% =======
%
%     saveas(P,FNAME)
%
% Input arguments
% ================
%
% * `P` [ preparser ] - Preparser object (preparsed file).
%
% * `FNAME` [ char ] - File name under which the preparsed code will be
% saved.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Substitute quoted strings back for the #(...) marks before
% saving the pre-parsed file.
c = labelsback(P);

if exist('FNAME','var') && ~isempty(FNAME)
    char2file(c,FNAME);
end

end