function [TFOR,TPARFOR] = testpar(THIS,N,varargin)
% testpar  Test performance of for versus parfor loops in evaluating posterior simulator.
%
% Syntax
% =======
%
%     [TFOR,TPARFOR] = testpar(POS,N,...)
%
% Input arguments
% ================
%
% * `POS` [ poster ] - Initialised posterior simulator object that will be
% evaluated `N` time.
%
% * `N` [ numeric ] - Number of times the posterior distribution will be
% evaluated for both for and parfor loops.
%
% Output arguments
% =================
%
%  * `TFOR` [ numeric ] - Time elapsed when running `N` times the posterior
%  simulator with a for loop.
%
%  * `TPARFOR` [ numeric ] - Time elapsed when running `N` times the
%  posterior simulator with a parfor loop.
%
% Options
% ========
%
% * `'progress='` [ `true` | *`false`* ] - Display progress bar in the command
% window.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes & Troy Matheson.

% Validate required inputs.
P = inputParser();
P.addRequired('POS',@(x) isa(x,'poster'));
P.addRequired('N',@isnumericscalar);
P.parse(THIS,N);

% Parse options.
% opt = passvalopt('poster.testpar',varargin{:});

%**************************************************************************

[TFOR,TPARFOR] = simulate(THIS,'testpar',N);

end