function [x,flag] = specget(THIS,QUERY)
% SPECGET  [Not a public function] Implement GET method for plan objects.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

x = [];
flag = true;

switch QUERY
    case {'exogenised','exogenized','onlyexogenised','onlyexogenized'}
        isonly = strncmp(QUERY,'only',4);
        x = struct();
        templ = tseries();
        for i = 1 : length(THIS.xlist)
            if isonly && ~any(THIS.xanchors(i,:))
                continue
            end
            x.(THIS.xlist{i}) = replace(templ,+THIS.xanchors(i,:).', ...
                THIS.startdate, ...
                [THIS.xlist{i},' Exogenised points']);
        end
    case {'endogenised','endogenized','onlyendogenised','onlyendogenized'}
        isonly = strncmp(QUERY,'only',4);
        x = struct();
        templ = tseries();
        for i = 1 : length(THIS.nlist)
            if isonly ...
                    && ~any(THIS.nanchorsreal(i,:)) ...
                    && ~any(THIS.nanchorsimag(i,:))
                continue
            end
            x.(THIS.nlist{i}) = replace(templ, ...
                +THIS.nanchorsreal(i,:).' + 1i*(+THIS.nanchorsimag(i,:).'), ...
                THIS.startdate, ...
                [THIS.nlist{i},' Endogenised points']);
        end
    case 'range'
        x = THIS.startdate : THIS.enddate;
        
    case {'start','startdate'}
        x = THIS.startdate;
        
    case {'end','enddate'}
        x = THIS.enddate;
        
    otherwise
        flag = false;
end

end
