function THIS = transpose(THIS)
% transpose  Transpose each page of matrix with names rows and columns.
%
% Syntax
% =======
%
%     X = transpose(X)
%     X = X.'
%
% Input arguments
% ================
% 
% * `X` [ namedmat ] - Input matrix or array with named rows and columns.
%
% Output arguments
% =================
%
% * `X` [ namedmat ] - Transpose of the input matrix; if it is more than
% 2-dimensional, each page of the matrix is transposed.
%
% Description
% ============
%
% Example
% ========

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

rownames = THIS.Rownames;
colnames = THIS.Colnames;

THIS = double(THIS);
n = ndims(THIS);
THIS = permute(THIS,[2,1,3:n]);
THIS = namedmat(THIS,colnames,rownames);

end