function d = zerodb(m,range,varargin)
% zerodb  Create model-specific zero-deviation database.
%
% Syntax
% =======
%
%     D = zerodb(M,RANGE)
%     D = zerodb(M,RANGE,NCOL)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object for which the zero database will be
% created.
%
% * `RANGE` [ numeric ] - Intended simulation range; the zero database will
% be created on a range that also automatically includes all the necessary
% lags.
%
% * `NCOL` [ numeric ] - Number of columns for each variable; the input
% argument `NCOL` can be only used with single-parameterisation models.
%
% Output arguments
% =================
%
% * `D` [ struct ] - Database with a tseries object filled with zeros for
% each linearised variable, a tseries object filled with ones for each
% log-linearised variables, and a scalar or vector of the currently
% assigned values for each model parameter.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% ZERODB, SSTATEDB

%**************************************************************************

d = mysourcedb(m,range,varargin{:},'deviation',true);

end
