function this = swap(this,options)
% SWAP  [Not a public function] Swap endogeneity and exogeneity of some parameters and some transition variables for steady-state solver.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

    endogenise = options.endogenise;
    exogenise = options.exogenise;

    if isempty(endogenise) && isempty(exogenise)
       return
    end
    if ~isempty(endogenise) && ischar(endogenise)
       endogenise = regexp(endogenise,'\w+','match');
    end
    if ~isempty(exogenise) && ischar(exogenise)
       exogenise = regexp(exogenise,'\w+','match');
    end
    endoPos = mynameposition(this,endogenise);
    exoPos = mynameposition(this,exogenise);
    endoValid = ~isnan(endoPos);
    exoValid = ~isnan(exoPos);
    if all(endoValid)
       endoValid = this.nametype(endoPos) == 4;
    end
    if all(exoValid)
       exoValid = this.nametype(exoPos) == 2;
    end
    if any(~endoValid)
       utils.error('model', ...
          'Cannot endogenise this name: ''%s''.', ...
          endogenise{~endoValid});
    end
    if any(~exoValid)
       utils.error('model', ...
          'Cannot exogenise this name: ''%s''.', ...
          exogenise{~exoValid});
    end
    nendo = length(endogenise);
    nexo = length(exogenise);
    if nendo ~= nexo
       utils.error('model', ...
          ['The number of exogenised variables and the number ', ...
          'endogenised parameters must match.']);
    end
    this.nametype(endoPos) = 2;
    this.nametype(exoPos) = 4;

    index = any(isnan(this.Assign(1,exoPos,:)),3);
    if any(index)
       utils.error('model', ...
          'This variable is exogenised to NaN: ''%s''.', ...
          this.name{exoPos(index)});
    end

end