function d = sstatedb(m,range,varargin)
% sstatedb  Create model-specific steady-state or balanced-growth-path database
%
% Syntax
% =======
%
%     D = sstatedb(M,RANGE)
%     D = sstatedb(M,RANGE,NCOL)
%
% Input arguments
% ================
%
% * `M` [ model ] - Model object for which the sstate database will be
% created.
%
% * `RANGE` [ numeric ] - Intended simulation range; the steady-state or
% balanced-growth-path database will be created on a range that also
% automatically includes all the necessary lags.
%
% * `NCOL` [ numeric ] - Number of columns for each variable; the input
% argument `NCOL` can be only used with single-parameterisation models.
%
% Output arguments
% =================
%
% * `D` [ struct ] - Database with a steady-state or balanced-growth path
% tseries object for each model variable, and a scalar or vector of the
% currently assigned values for each model parameter.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% ZERODB, SSTATEDB

%**************************************************************************

d = mysourcedb(m,range,varargin{:},'deviation',false);

end