function m = saveobj(m)
% SAVEOBJ  [Not a public function] Prepare model object for saving.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Convert function handles to char to minimise disk space needed.

% Extract the converted equations into local variables to speed up the
% executiona considerably. This is a Matlab issue.

eqtnF = m.eqtnF;
eqtnN = m.eqtnN;
deqtnF = m.deqtnF;
ceqtnF = m.ceqtnF;

neqtn = length(m.eqtn);
for i = 1 : neqtn
    if isa(eqtnF{i},'function_handle')
        eqtnF{i} = func2str(eqtnF{i});
    end
    if isa(eqtnN{i},'function_handle')
        eqtnN{i} = func2str(eqtnN{i});
    end
    if isa(deqtnF{i},'function_handle')
        deqtnF{i} = func2str(deqtnF{i});
    elseif iscell(deqtnF{i})
        for j = 1 : length(deqtnF{i})
            if isa(deqtnF{i}{j},'function_handle');
                deqtnF{i}{j} = func2str(deqtnF{i}{j});
            end
        end
    end
    if isa(ceqtnF{i},'function_handle')
        ceqtnF{i} = func2str(ceqtnF{i});
    end    
end

m.eqtnF = eqtnF;
m.eqtnN = eqtnN;
m.deqtnF = deqtnF;
m.ceqtnF = ceqtnF;

end
