function d = reporting(m,varargin)
% reporting  Run reporting equations.
%
% Syntax
% =======
%
%     d = reporting(m,d,range,...)
%
% Input arguments
% ================
%
% * `m` [ model ] - Model object with reporting equations.
%
% * `d` [ struct ] - Input database that will be used to evaluate the
% reporting equations.
%
% * `range` [ numeric ] - Date range on which the reporting equations will
% be evaluated.
%
% Output arguments
% =================
%
% * `d` [ struct ] - Output database with reporting variables.
%
% Options
% ========
%
% * `'dynamic='` [ *`true`* | `false` ] - If true, equations will be evaluated
% period by period allowing for own lags; if false, equations will be
% evaluated en bloc for all periods.
%
% * `'merge='` [ *`true`* | `false` ] - Merge output database with input datase.
%
% Description
% ============
%}

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

d = reporting(m.outside,varargin{:});

end