function warning_(code,varargin)
% warning_  Model object warning look-up table.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if ~iswarning('model')
   return
end

switch code
   % Warnings parsing the model file.
   case -1
      msg = ...
         ['Stop using @ or ! in front of math functions in IRIS codes. ', ...
         'This will generate an error in future versions if IRIS: ''%s''.'];
   % Warnings dealing with model object.
   case 1
      msg = 'Cannot find/match this variable name: ''%s''.';
   case 2
      msg = 'This parameter is not available: ''%s''.';
   case 4
      msg = 'Log declarations disregarded in linear models.';
   case 7
      msg = 'Invalid assignment of parameters.';
   case 8
      msg = 'Time series not available: ''%s''.';
   case 12
      msg = 'Parameter changed since last steady state and/or solution: ''%s''.';
   case 13
      msg = 'Cannot get growth rates for non-linear models.';
   case 14
      msg = 'Numerical instability. Status not reliable: ''%s''.';
   case 15
      msg = 'No anchored variable(s) or no free residual(s). Plain simulation run instead.';
   case 18
      msg = '%sidentified anchoring system. (Data points exogenized: %g. Data points endogenized: %g.)';
   case 19
      msg = 'Model solution expanded forward to t+%g.';
   case 20
      msg = 'Model solution not available. Use SOLVE first.';
   case 21
      msg = 'No effect of anticipated residuals (backward-looking model).';
   case 23
      msg = 'Forward expansion already available up to t+%g.';
   case 25
      msg = 'Cannot fix steady state for this variable: ''%s''.';
   case 28
      msg = 'Not enough information to compute some of diffuse initial conditions or out-of-likelihood parameters.';
   case 30
      msg = 'Cannot evaluate !if..!else..!end expression: ''%s''. FALSE used instead.';
   case 31
      msg = 'Cannot find parameter ''%s''.';
   case 35
      msg = 'Steady state for this variable is not available: ''%s''.';
   case 36
      msg = 'Cannot find this equation label: ''%s''.';
   case 37
      msg = 'Symbolic Math Toolbox not installed. Cannot calculate symbolic derivatives.';
   case 39
      msg = 'Unrecognised objective function.';
   case 40
      msg = 'Underdetermined conditional forecast system; forecast not computed:%s.';
   case 41
      msg = 'Unable to use large scale method for objective functions other than -loglik.';
   case 42
      msg = 'Optimal rule convergence not reached:%s.';
   case 43
      msg = 'Unable to plug optimal rule into original model. Using iterated policy function instead.';
   case 45
      msg = 'Forward expansion not available:%s.';
   case 47
      msg = 'Option ''removezerostd'' ignored in models with multiple parameterisations.';
   case 51
      msg = 'No data available for any measurement variable:%s.';
   case 52
      msg = 'Cannot symbolically evaluate some of the derivative(s): ''%s''';
   case 55
      msg = 'Cannot compute linear steady state because solution is not available:%s.';
end

if code < 0
   % Add file name to model file warnings.
   msg = [sprintf('Warning parsing file(s) ''%s''. ',varargin{1}), ...
      msg];
   varargin(1) = [];
end

if ~isempty(varargin)
   list = varargin{1};
else
   list = {};
end
if ~iscell(list)
   list = {list};
end

printmsg('model','warning',msg,list,code);

end
