function X = myreshape(THIS,XX)
% myreshape  [Not a public function] Reshape transition vector data for output.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

s = size(XX);
XX = XX(:,:,:);
nper = size(XX,2);

realid = real([THIS.solutionid{2}]);
imagid = imag([THIS.solutionid{2}]);
maxlag = -min(imagid);
offset = sum(THIS.nametype == 1);

X = nan(sum(THIS.nametype == 2),nper+maxlag,size(XX,3));
for i = find(imagid == 0)
    X(realid(i)-offset,maxlag+1:end,:) = XX(i,:,:);
    if any(imagid(realid == realid(i)) < 0)
        for j = 1 : maxlag
            pos = realid == realid(i) & imagid == -j;
            if any(pos)
                X(realid(i)-offset,maxlag+1-j,:) = XX(pos,1,:);
            end
        end
    end
end

if length(s) > 3
    X = reshape(X,[size(X,1),size(X,2),s(3:end)]);
end

end