function COV = myproposalcov(THIS,HESS,BOUNDHIT,RANGE,S,LOGLIKOPT)
% MYPROPOSALCOV  [Not a public function] Approx cov matrix of the parameter estimates of parameters with slack constraint.
%
% Backed IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

np = length(S.plist);
COV = nan(np);

try
    % Create temporary option struct `loglikopt1` for `mydiffloglik` with
    % pevec, F, and Finf included. The original `loglikopt` struct is used
    % again below in `mykalman`, that's why we do not it directly but
    % create a temporary struct instead.
    F = nan(np);
    if any(~BOUNDHIT)
        % TODO: This part does not work with s.domain == 'f'. Use `fisher` in
        % that case, but allow |'relative=' true| in `fisher`.
        LOGLIKOPT.retpevec = true;
        LOGLIKOPT.retf = true;
        [~,~,F(~BOUNDHIT,~BOUNDHIT)] = ...
            mydiffloglik(THIS,S.data,RANGE, ...
            S.assignpos(~BOUNDHIT),S.stdcorrpos(~BOUNDHIT), ...
            S,LOGLIKOPT);
    end
    % Add information from priors.
    F = F + HESS{2};
catch %#ok<CTCH>
    % Approximate Hessian from optimization procedure.
    F = HESS{1};
end

% Invert information matrix to approximate cov matrix.
COV(~BOUNDHIT,~BOUNDHIT) = inv(F(~BOUNDHIT,~BOUNDHIT));

end