function [OBJ,V,DELTA,PDELTA] = myoutoflik(L0,L1,L2,L3,NOBS,OPT)
% MYOUTOFLIK  [Not a public function] Estimate out-of-lik parameters and sum up log-likelihood function components.
%
% Backed IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% L0 := sum log det F;
% L1 := sum pe Fi pe;
% L2 := sum Mt Fi M;
% L3 := sum Mt Fi pe;

if ~isfield(OPT,'objective')
    OPT.objective = 1;
end

% Estimate user-requested out-of-lik parameters.
if ~isempty(L2) && ~isempty(L3)
    L2i = pinv(L2);
    DELTA = L2i * L3;
    DELTA = DELTA(:).';
    L1 = L1 - DELTA*L3;
    PDELTA = L2i;
else
    DELTA = zeros(1,0);
    PDELTA = zeros(0);
end

% Estimate common variance factor.
V = 1;
if OPT.relative && OPT.objective == 1
    if NOBS > 0
        V = L1 / NOBS;
        L0 = L0 + NOBS*log(V);
        L1 = L1 / V;
    else
        L1 = 0;
    end
end

% Put together objective function.
if OPT.objective == 1
    % Minus log likelihood.
    OBJ = (NOBS*log(2*pi) + L0 + L1) / 2;
else
    % Weighted prediction errors.
    OBJ = L1/2;
end

end