function m = mymodel2model(m,a,opt)
% MYMODEL2MODEL  [Not a public function] Rebuild model object properties.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

% Assign user comment if it is non-empty, otherwise use what has been
% found in the model code.
if ~isempty(opt.comment)
    m.Comment = opt.comment;
end

% Differentiation step size.
m.epsilon = opt.epsilon;

% Time origin (base year) for deterministic trends.
if ~isempty(opt.torigin)
    m.torigin = floor(opt.torigin);
end

% Create model-specific meta data.
if any(m.nonlin)
    % Do not remove leads from state space vector if there are
    % non-linearised equations.
    % TODO: More sophisticated check which leads are actually needed in
    % non-linerised equations.
    opt.removeleads = false;
end
m = mymeta(m,opt);

% Create equations for non-linear simulations; these can be created only
% after we know the solution ids.
if any(m.nonlin)
    m = mynonlineqtn(m);
end

% Assign default stddevs.
if ~isnan(opt.std) && ~isempty(opt.std)
    defaultstd = opt.std;
elseif m.linear
    defaultstd = 1;
else
    defaultstd = log(1.01);
end

% Pre-allocate solution matrices etc. Also assign zero steady states to
% shocks and default stdevs.
do_prealloc();
if ~isempty(a) ...
        && isstruct(a) ...
        && ~isempty(fieldnames(a))
    % Check number of alt params in input database. Exclude shocks.
    list = m.name(m.nametype ~= 3);
    maxlength = 1;
    for i = 1 : length(list)
        if isfield(a,list{i}) && isnumeric(a.(list{i}))
            a.(list{i}) = transpose(a.(list{i})(:));
            maxlength = max([maxlength,length(a.(list{i}))]);
        end
    end
    % Expand number of alt params if necessary.
    if maxlength > 1
        m = alter(m,maxlength);
    end
    m = assign(m,a);
end

% Pre-compute symbolic derivatives of
% * transition and measurement equations wrt variables,
% * dtrends equations wrt parameters (always).
m = mysymbdiff(m);

% Convert model equations to anonymous functions.
m = myeqtn2afcn(m);

% Refresh dynamic links.
if ~isempty(m.Refresh) % && any(~isnan(m.Assign(:)))
    m = refresh(m);
end

% Nested functions.

%**************************************************************************
    function do_prealloc()
        if issparse(m.occur)
            nt = size(m.occur,2)/length(m.name);
        else
            nt = size(m.occur,3);
        end
        
        nderiv = nt*sum(m.nametype <= 3);
        n = sum(m.eqtntype <= 2);
        m.deriv0.c = zeros(n,1);
        m.deriv0.f = sparse(zeros(n,nderiv));
        tempeye = -eye(n);
        m.deriv0.n = tempeye(:,m.nonlin);
        
        % Sizes of system matrices (different from solution matrices).
        ny = sum(m.nametype == 1);
        nx = length(m.systemid{2});
        ne = sum(m.nametype == 3);
        nf = sum(imag(m.systemid{2}) >= 0);
        nb = nx - nf;
        m.system0.K{1} = zeros(ny,1);
        m.system0.K{2} = zeros(nx,1);
        m.system0.A{1} = sparse(zeros(ny,ny));
        m.system0.B{1} = sparse(zeros(ny,nb));
        m.system0.E{1} = sparse(zeros(ny,ne));
        m.system0.N{1} = [];
        m.system0.A{2} = sparse(zeros(nx,nx));
        m.system0.B{2} = sparse(zeros(nx,nx));
        m.system0.E{2} = sparse(zeros(nx,ne));
        m.system0.N{2} = zeros(nx,sum(m.nonlin));
        
        m.Assign = nan(1,length(m.name));
        m.Assign(m.nametype == 3) = 0;
        m.Assign0 = m.Assign;
        m.stdcorr = zeros(1,ne+ne*(ne-1)/2);
        m.stdcorr(1,1:ne) = defaultstd;
        
        ny = length(m.systemid{1});
        nx = length(m.systemid{2});
        nb = sum(imag(m.systemid{2}) < 0);
        nf = nx - nb;
        ne = length(m.systemid{3});
        fkeep = ~m.metadelete;
        nfkeep = sum(fkeep);
        nn = sum(m.nonlin);
        
        m.solution{1} = nan(nfkeep+nb,nb); % T
        m.solution{2} = nan(nfkeep+nb,ne); % R
        m.solution{3} = nan(nfkeep+nb,1); % K
        m.solution{4} = nan(ny,nb); % Z
        m.solution{5} = nan(ny,ne); % H
        m.solution{6} = nan(ny,1); % D
        m.solution{7} = nan(nb,nb); % U
        m.solution{8} = nan(nfkeep+nb,nn); % M -- non-lin addfactors.
        
        m.Expand{1} = nan(nb,nf); % Xa
        m.Expand{2} = nan(nfkeep,nf); % Xf
        m.Expand{3} = nan(nf,ne); % Ru
        m.Expand{4} = nan(nf,nf); % J
        m.Expand{5} = nan(nf,nf); % J^k
        m.Expand{6} = nan(nf,nn); % Mu -- non-lin addfactors.
        
        m.eigval = nan(1,nx);
        m.icondix = false(1,nb);
    end
% do_prealloc().

end