function [Y,F,PE,PDELTA,PRED,SMOOTH] = mykalmanoutput(THIS,Y,RANGE)
% mykalmanoutput  [Not a public function] Prepare final user output from
% Kalman filter.
%
% Backed IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

isemptynumericfunc = @(x) isnumeric(x) && isempty(x);

F = [];
PE = [];
PDELTA = [];
PRED = [];
SMOOTH = [];

template = tseries();

if isfield(Y,'F') && ~isemptynumericfunc(Y.F)
    doretf();
end

if isfield(Y,'Pdelta') && ~isemptynumericfunc(Y.Pdelta)
    doretpdelta();
end

if isfield(Y,'pe') && ~isemptynumericfunc(Y.pe)
    doretpe();
end

if isfield(Y,'predmean') && ~isemptynumericfunc(Y.predmean)
    doretpred();
end

if isfield(Y,'smoothmean') && ~isemptynumericfunc(Y.smoothmean)
    doretsmooth();
end

% Nested functions.

%**************************************************************************
    function doretf()
        Y.F = permute(Y.F,[3,1,2,4]);
        F = template;
        F.start = RANGE(1);
        F.data = Y.F;
        Y.F = [];
        F.Comment = cell(1,size(F.data,2),size(F.data,3),size(F.data,4));
        F.Comment(:) = {''};
        F.UserData = [];
        F = mytrim(F);
    end
% doretpe().

%**************************************************************************
    function doretpdelta()
        PDELTA = Y.Pdelta;
        Y.Pdelta = [];
    end
% doretpdelta().

%**************************************************************************
    function doretpe()
        % doretpe  Return prediction error database.
        % Create database with prediction errors for each measurement variable.
        PE = struct();
        ndata = size(Y.pe,3);
        islog = THIS.log(THIS.nametype == 1);
        Y.pe(islog,:,:) = exp(Y.pe(islog,:,:));
        Y.pe = permute(Y.pe,[2,3,1]);
        for ii = find(THIS.nametype == 1)
            name = THIS.name{ii};
            PE.(name) = template;
            PE.(name).start = RANGE(1);
            PE.(name).data = Y.pe(:,:,ii);
            PE.(name).Comment = cell(1,ndata);
            PE.(name).Comment(:) = {name};
            PE.(name) = mytrim(PE.(name));
        end
        Y.pe = [];
    end
% doretpe().

%**************************************************************************
    function doretpred()
        PRED = struct();
        if isfield(Y,'predstd') || isfield(Y,'predmse')
            PRED.mean = myhdata2tseries(THIS,Y.predmean,RANGE);
            Y.predmean = [];
            if isfield(Y,'predstd')
                PRED.std = myhdata2tseries(THIS,Y.predstd,RANGE);
                Y.predstd = [];
            end
            if isfield(Y,'predmse')
                Y.predmse = permute(Y.predmse,[3,1,2,4]);                
                PRED.mse = template;
                PRED.mse.start = RANGE(1);
                PRED.mse.data = Y.predmse;
                PRED.mse.Comment = cell(1, ...
                    size(Y.predmse,2), ...
                    size(Y.predmse,3), ...
                    size(Y.predmse,4));
                PRED.mse.Comment(:) = {''};
                PRED.mse = mytrim(PRED.mse);
                Y.predmse = [];
            end
        else
            PRED = myhdata2tseries(THIS,Y.predmean,RANGE);
            Y.predmean = [];
        end
    end
% doretpred().

%**************************************************************************
    function doretsmooth()
        SMOOTH = struct();
        if isfield(Y,'smoothstd') || isfield(Y,'smoothmse')
            SMOOTH.mean = myhdata2tseries(THIS,Y.smoothmean,RANGE);
            Y.smoothmean = [];
            if isfield(Y,'smoothstd')
                SMOOTH.std = myhdata2tseries(THIS,Y.smoothstd,RANGE);
                Y.smoothstd = [];
            end
            if isfield(Y,'smoothmse')
                Y.smoothmse = permute(Y.smoothmse,[3,1,2,4]);
                SMOOTH.mse = template;
                SMOOTH.mse.start = RANGE(1);
                SMOOTH.mse.data = Y.smoothmse;
                SMOOTH.mse.Comment = cell(1, ...
                    size(Y.smoothmse,2), ...
                    size(Y.smoothmse,3), ...
                    size(Y.smoothmse,4));
                SMOOTH.mse.Comment(:) = {''};
                SMOOTH.mse = mytrim(SMOOTH.mse);
                Y.smoothmse = [];
            end
        else
            SMOOTH = myhdata2tseries(THIS,Y.smoothmean,RANGE);
            Y.smoothmean = [];
        end
    end
% doretsmooth().

end