function myhdataassign(THIS,H,COLS,Y,X,E,varargin)
% hdatainit  [Not a public function] Assign currently processed data to HDATAOBJ.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if any(strcmpi(varargin,'-std'))
    Y = xxvar2std(Y);
    X = xxvar2std(X);
    E = xxvar2std(E);
end

maxlag = -min(imag(THIS.solutionid{2}));
nper = max([size(Y,2),size(X,2),size(E,2)]);
t = maxlag + (1 : nper);

if ~isempty(Y)
    yid = THIS.solutionid{1};
    for i = 1 : length(yid)
        name = THIS.name{real(yid(i))};
        H.data.(name)(t,COLS) = permute(Y(i,:,:),[2,3,1]);
    end
end

if ~isempty(X)
    xid = THIS.solutionid{2};
    realid = real(xid);
    imagid = imag(xid);
    if ~any(strcmpi(varargin,'-nopresample'))
        
        for i = find(imagid < 0)
            lag = -imagid(i);
            name = THIS.name{realid(i)};            
            H.data.(name)(maxlag+1-lag,COLS) = ...
                permute(X(i,1,:),[2,3,1]);
        end
    end
    for i = find(imagid == 0)
        name = THIS.name{realid(i)};
        H.data.(name)(t,COLS) = ...
            permute(X(i,:,:),[2,3,1]);
    end
end

if ~isempty(E)
    eid = THIS.solutionid{3};
    for i = 1 : length(eid)
        name = THIS.name{real(eid(i))};
        H.data.(name)(t,COLS) = permute(E(i,:,:),[2,3,1]);
    end
end

end

% Subfunctions.

%**************************************************************************
function D = xxvar2std(D)
% xxvar2std  Convert vectors of vars to vectors of stdevs.

if isempty(D)
    return
end

tol = 1e-15;
index = D < tol;
if any(index(:))
    D(index) = 0;
end
D = sqrt(D);

end
% xxvar2std().