function [SSPACEPOS,NAMEPOS,SSPACEPOSLAG] = myfindsspacepos(THIS,SELECT,varargin)
% MYFINDSSPACEPOS  [Not a public function] Find position of variables in sspace vector.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

throwerror = any(strcmp(varargin,'error'));

if ischar(SELECT)
    SELECT = regexp(SELECT,'[\w\{\}\(\)\+\-]+','match');
end

% Remove blank spaces.
SELECT = regexprep(SELECT,'\s+','');

%**************************************************************************

%removelogfunc = @(x) regexprep(x,'log\((.*?)\)','$1');
%select = removelogfunc(SELECT);
nz = length(SELECT);

% Combine transition and measurement variables.
sspacevec = [THIS.solutionvector{1:2}];
% sspacevec = removelogfunc(sspacevec);

SSPACEPOS = nan(1,nz);
NAMEPOS = nan(1,nz);
for i = 1 : nz
    % Position of the requested variable in the state-space vector.
    index = strcmp(SELECT{i},sspacevec);
    if ~any(index)
        continue
    end
    SSPACEPOS(i) = find(index);
    
    % Position of the requested variable in the list of model names.
    index = strcmp(THIS.name,SELECT{i}) & THIS.nametype <= 2;
    if ~any(index)
        continue
    end
    NAMEPOS(i) = find(index);
end

if nargout == 1
    nanpos = isnan(SSPACEPOS);
    if throwerror && any(nanpos)
        utils.error('model', ...
            'Cannot find this variable in the state-space vectors: ''%s''.', ...
            SELECT{nanpos});
    end
    return
end

if nargout == 2
    nanpos = isnan(NAMEPOS);
    if throwerror && any(nanpos)
        utils.error('model', ...
            'Cannot find this variable in the state-space vectors: ''%s''.', ...
            SELECT{nanpos});
    end
    return
end

SSPACEPOSLAG = xxsspaceposlag(THIS,SELECT,SSPACEPOS);

nanpos = isnan(SSPACEPOSLAG);
if throwerror && any(nanpos)
    utils.error('model', ...
        'Cannot find this variable in the state-space vectors: ''%s''.', ...
        SELECT{nanpos});
end

end

% Subfunctions.

%**************************************************************************
function X = xxsspaceposlag(THIS,USERNAME,SSPACEPOS)
% xxsspaceposlag  Return position in the extended solutionid vector for
% transition variables with a lag larger than the maximum lag present in
% solutionid.
X = SSPACEPOS;
solutionid = [THIS.solutionid{1:2}];
logname = THIS.name;
logname(THIS.log) = regexprep(logname(THIS.log),'.*','log($0)');
for i = find(isnan(X))
    username = USERNAME{i};
    lag  = regexp(username,'\{.*?\}','match','once');
    username = regexprep(username,'\{.*?\}','','once');
    if isempty(lag)
        continue
    end
    namepos = strcmp(logname,username) & THIS.nametype == 2;
    if ~any(namepos)
        continue
    end
    namepos = find(namepos,1);
    % `lag` is a negative number.
    lag = sscanf(lag,'{%g}');
    if ~isnumericscalar(lag) || ~isfinite(lag)
        continue
    end
    % `maxlag` is a negative number.
    maxlag = min(imag(solutionid(real(solutionid) == namepos)));
    index = solutionid == namepos + 1i*maxlag;
    solutionpos = find(index,1);
    X(i) = solutionpos + 1i*round(lag - maxlag);
end
end
% xxsspaceposlag().