function THIS = myeqtn2afcn(THIS)
% myeqtn2afcn  [Not a public function] Convert equation strings to anonymous functions.
%
% Backed IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

removefunc = @(x) regexprep(x,'@\(.*?\)','','once');

% Extract the converted equations into local variables to speed up the
% executiona considerably. This is a Matlab issue.

% Full dynamic equations
%========================

eqtnF = THIS.eqtnF;

% Full measurement and transition equations.
for i = find(THIS.eqtntype <= 2)
    % Full model equations.
    if ~ischar(eqtnF{i})
        continue
    end
    if isempty(eqtnF{i})
        eqtnF{i} = @(x,t,L) 0;
    else
        eqtnF{i} = removefunc(eqtnF{i});
        eqtnF{i} = str2func(['@(x,t,L) ',eqtnF{i}]);
    end
end
% Dtrend equations.
for i = find(THIS.eqtntype == 3)
    % Full model equations.
    if ~ischar(eqtnF{i})
        continue
    end
    if isempty(eqtnF{i})
        eqtnF{i} = @(x,t,ttrend) 0;
    else
        eqtnF{i} = removefunc(eqtnF{i});
        eqtnF{i} = str2func(['@(x,t,ttrend) ',eqtnF{i}]);
    end
end
% Dynamic link equations.
for i = find(THIS.eqtntype == 4)
    if ~ischar(eqtnF{i})
        continue
    end
    if isempty(eqtnF{i})
        eqtnF{i} = [];
    else
        eqtnF{i} = removefunc(eqtnF{i});
        eqtnF{i} = str2func(['@(x,t) ',eqtnF{i}]);
    end
end

THIS.eqtnF = eqtnF;

% Derivatives and constant terms
%================================

deqtnF = THIS.deqtnF;
ceqtnF = THIS.ceqtnF;

% Derivatives of transition and measurement equations wrt variables and
% shocks.
for i = find(THIS.eqtntype <= 2)
    deqtnF{i} = removefunc(deqtnF{i});
    deqtnF{i} = str2func(['@(x,t,L) ',deqtnF{i}]);
    if THIS.linear
        if ischar(ceqtnF{i})
            ceqtnF{i} = removefunc(ceqtnF{i});
            ceqtnF{i} = str2func(['@(x,t,L) ',ceqtnF{i}]);
        end
    end        
end

% Derivatives of dtrend equations wrt parameters to anonymous functions.
for i = find(THIS.eqtntype == 3)
    if isempty(deqtnF{i})
        continue
    end
    for j = 1 : length(deqtnF{i})
        deqtnF{i}{j} = removefunc(deqtnF{i}{j});
        deqtnF{i}{j} = str2func(['@(x,t,ttrend) ',deqtnF{i}{j}]);
    end
end

THIS.deqtnF = deqtnF;
THIS.ceqtnF = ceqtnF;

% Non-linear equations
%======================

eqtnN = THIS.eqtnN;

% Non-linearised equations.
for i = find(THIS.nonlin)
    eqtnN{i} = removefunc(eqtnN{i});
    eqtnN{i} = str2func(['@(x,e,p,t,L) ',eqtnN{i}]);
end

THIS.eqtnN = eqtnN;

end