function varargout = mydtrendsrequest(THIS,REQUEST,RANGE,ALT)
% mydtrendsrequest   [Not a public function] Request deterministic trends.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

if nargin < 3
    RANGE = [];
end

if nargin < 4 || any(isinf(ALT))
    ALT = 1 : size(THIS.Assign,3);
elseif islogical(ALT)
    ALT = find(ALT);
else
    ALT = transpose(ALT(:));
end
nalt = numel(ALT);

%**************************************************************************

ny = sum(THIS.nametype == 1);
nper = numel(RANGE);

switch REQUEST
    case 'sstate'
        eqtn = THIS.eqtnF(THIS.eqtntype == 3);
        const = zeros(ny,nalt);
        ttrend = zeros(ny,nalt);
        count = 0;
        vec = @(x) x(:);
        for ialt = ALT
            count = count + 1;
            x = THIS.Assign(1,:,min(ialt,end));
            const(:,count) = vec(cellfun(@(fcn) fcn(x,1,0),eqtn));
            ttrend(:,count) = ...
                vec(cellfun(@(fcn) fcn(x,1,1),eqtn)) - const(:,count);
        end
        varargout{1} = const;
        varargout{2} = ttrend;
    case 'range'
        eqtn = THIS.eqtnF(THIS.eqtntype == 3);
        ttrend = myrange2ttrend(THIS,RANGE);
        W = zeros(ny,nper,nalt);
        count = 0;
        if ~isempty(RANGE)
            for ialt = ALT
                count = count + 1;
                x = THIS.Assign(1,:,min(ialt,end));
                for j = 1 : ny
                    W(j,:,count) = eqtn{j}(x,1,ttrend);
                end
            end
        end
        varargout{1} = W;
end

end