function [YA,XA,EAREAL,EAIMAG,YC,XC,QA] = myanchors(THIS,P,RANGE)
% myanchors  [Not a public function] Get simulation plan anchors for model variables.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% Check date frequencies.
if datfreq(P.startdate) ~= datfreq(RANGE(1)) ...
        || datfreq(P.enddate) ~= datfreq(RANGE(end))
    utils.error('model', ...
        'Simulation range and plan range must be the same frequency.');
end

% Adjust plan range to simulation range if not equal.
if ~datcmp(P.startdate,RANGE(1)) ...
        || ~datcmp(P.enddate,RANGE(end))
    P = P(RANGE);
end

%**************************************************************************

ny = sum(THIS.nametype == 1);
nx = length(THIS.solutionid{2});
nper = length(RANGE);
neqtn = length(THIS.eqtnN);

% Anchors for exogenised measurement variables, and conditioning measurement
% variables.
YA = P.xanchors(1:ny,:);
YC = P.canchors(1:ny,:);

% Anchors for exogenised transition variables, and conditioning transition
% variables.
realid = real(THIS.solutionid{2});
imagid = imag(THIS.solutionid{2});
XA = false(nx,nper);
XC = false(nx,nper);
for j = find(THIS.nametype == 2)
    index = realid == j & imagid == 0;
    XA(index,:) = P.xanchors(j,:);
    XC(index,:) = P.canchors(j,:);
end

% Anchors for endogenised shocks.
EAREAL = P.nanchorsreal;
EAIMAG = P.nanchorsimag;

% Anchors for non-linear equations.
QA = false(neqtn,nper);
QA(THIS.nonlin,:) = P.qanchors;

end