function m = loadobj(m)
% LOADOBJ  [Not a public function] Prepare model object for use in workspace and handle bkw compatibility.
%
% Backend IRIS function.
% No help provided.

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

options = passvalopt('model.model');

if isstruct(m)
    m = model(m);
end

ny = sum(m.nametype == 1);
[nx,nb,nalt] = size(m.solution{1});

% Convert array of occurences to sparse matrix.
if ~issparse(m.occur)
    m.occur = sparse(m.occur(:,:));
end

% Add empty dtrend equations if missing.
if ny > 0 && sum(m.eqtntype == 3) == 0
    m.eqtn(end+(1:ny)) = {''};
    m.eqtnS(end+(1:ny)) = {''};
    m.eqtnF(end+(1:ny)) = {@(x,t,ttrend)0};
    m.eqtnlabel(end+(1:ny)) = {''};
    m.eqtntype(end+(1:ny)) = 3;
    m.occur(end+(1:ny),:) = false;
end

% Store only non-empty dynamic links.
link = m.eqtn(m.eqtntype == 4);
emptylink = cellfun(@isempty,link);
if any(emptylink)
    occur = m.occur(m.eqtntype == 4,:);
    linklabel = m.eqtnlabel(m.eqtntype == 4);
    linkF = m.eqtnF(m.eqtntype == 4);
    linknonlin = m.nonlin(m.eqtntype == 4);
    m.eqtn(m.eqtntype == 4) = [];
    m.eqtnlabel(m.eqtntype == 4) = [];
    m.eqtnF(m.eqtntype == 4) = [];
    m.nonlin(m.eqtntype == 4) = [];
    m.occur(m.eqtntype == 4,:) = [];
    m.eqtntype(m.eqtntype == 4) = [];
    m.eqtn = [m.eqtn,link(m.Refresh)];
    m.eqtnlabel = [m.eqtnlabel,linklabel(m.Refresh)];
    m.eqtnF = [m.eqtnF,linkF(m.Refresh)];
    m.nonlin = [m.nonlin,linknonlin(m.Refresh)];
    m.occur = [m.occur;occur(m.Refresh,:)];
    m.eqtntype = [m.eqtntype,4*ones(size(m.Refresh))];
end

% Occurence of names in steady-state equations.
if isempty(m.occurS) && ~m.linear
    m.occurS = any(m.occur,3);
end

% Add flags and deriv0.n for equations earmarked for non-linear
% simulations.
if isempty(m.nonlin)
    m.nonlin = false(size(m.eqtn));
end

% Non-linearised equations.
if isempty(m.eqtnN)
    m = mynonlineqtn(m);
end

% Derivative step size.
if isempty(m.epsilon)
    m.epsilon = options.epsilon;
end

% Base year for dtrends.
if isempty(m.torigin)
    m.torigin = options.torigin;
end

% Effect of add-factor on transition equations.
if ~isfield(m.system0,'N') || isempty(m.system0.N)
    m.system0.N = {[],zeros(nx,0)};
end
if ~isfield(m.deriv0,'n') || isempty(m.deriv0.n)
    m.deriv0.n = zeros(ny+nx,0);
end

% Effect of add-faactors in solution for non-linear equations.
if length(m.solution) < 8 || isempty(m.solution{8})
    m.solution{8} = nan(nx,0,nalt);
end

if length(m.Expand) < 6 || isempty(m.Expand{6})
    % The size of Expand{6} in 1st dimension is the number of fwl variables
    % *before* we remove the double occurences from state space. `Expand{6}`
    % can be empty also in nonlinear bkw models; in that case, we need to set
    % the size in second dimension appropriately.
    m.Expand{6} = nan(size(m.Expand{3},1),size(m.Expand{6},2),nalt);
end

if isempty(m.stdcorr)
    ne = sum(m.nametype == 3);
    nname = length(m.name);
    stdvec = m.Assign(1,end-ne+1:end,:);
    m.stdcorr = stdvec;
    m.stdcorr(end+(1:ne*(ne-1)/2)) = 0;
    m.Assign(:,end-ne+1:end,:) = [];
    m.Assign0(:,end-ne+1:end,:) = [];
    occur = reshape(full(m.occur), ...
        [size(m.occur,1),nname,size(m.occur,2)/nname]);
    occur(:,end-ne+1:end,:) = [];
    m.occur = sparse(occur(:,:));
    m.occurS = occur(:,end-ne+1:end);
    m.name(:,end-ne+1:end) = [];
    m.nametype(:,end-ne+1:end) = [];
    m.namelabel(:,end-ne+1:end) = [];
    m.log(:,end-ne+1:end) = [];
end

if isempty(m.solutionvector) ...
        || all(cellfun(@isempty,m.solutionvector))
    m.solutionvector = { ...
        myvector(m,'y'), ...
        myvector(m,'x'), ...
        myvector(m,'e'), ...
        };
end

if isempty(m.multiplier)
    m.multiplier = false(size(m.name));
end

if iscell(m.Export)
    Export = struct('filename',{},'content',{});
    for i = 1 : 2 : length(m.Export)
        Export(end+1).filename = m.Export{i}; %#ok<AGROW>
        Export(end).content = m.Export{i+1};
    end
    m.Export = Export;
elseif isempty(m.Export)
    m.Export = struct('filename',{},'content',{});
end

if isempty(m.userdifflist)
    m.userdifflist = cell(1,0);
end

% Convert equation strings back to anonymous functions.
try
    m = myeqtn2afcn(m);
catch %#ok<CTCH>
    % The function `myeqtn2afcn` may fail because of an old structure of
    % derivatives or missing equations for constant terms in linear models.
    m = mysymbdiff(m);
    m = myeqtn2afcn(m);
end

% Create and save carry-around files.
export(m);

end