function varargout = isname(m,varargin)
% isname  True if a string is a model's variable, shock or parameter name.
%
% Syntax
% =======
%
%     [flag,flag,...] = isname(m,name,name,...)
%
% Input arguments
% ================
%
% * `m` [ model ] - Model object.
%
% * `name` [ char ] - A text string that will be compared with the model
% object's names.
%
% Output arguments
% =================
%
% * `flag` [ `true` | `false` ] - True if the tested string is the model
% object's name.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

for i = 1 : length(varargin)
    index = strcmp(m.name,varargin{i});
    if any(index)
        varargout{i} = m.nametype(index);
    else
        varargout{i} = 0;
    end
end

end
