function flag = islog(m,name)
% islog  True for log-linearised variables.
%
% Syntax
% =======
%
%     flag = islog(m,name)
%
% Input arguments
% ================
%
% * `m` [ model ] - Model object.
%
% * `name` [ char | cellstr ] - Name or names of model variable(s).
%
% Output arguments
% =================
%
% * `flag` [ `true` | `false` ] - True for variables declared as log-linear in
% a non-linear model.
%
% Description
% ============
%
% Example
% ========
% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

% Parse input arguments.
P = inputParser();
P.addRequired('m',@ismodel);
P.addRequired('name',@(x) ischar(x) || iscellstr(x));
P.parse(m,name);

if ischar(name)
    name = regexp(name,'\w+','match');
end

%**************************************************************************

flag = false(size(name));
valid = true(size(name));
for i = 1 : length(name)
    index = strcmp(m.name,name{i});
    if any(index)
        flag(i) = m.log(index);
    else
        valid(i) = false;
    end
end

if any(~valid)
    utils.error('model', ...
        ['This name does not exist ', ...
        'in the model object: ''%s''.'], ...
        name{~valid});
end

end
