function m = horzcat(m,varargin)
% horzcat  Combine two compatible model objects in one object with multiple parameterisations.
%
% Syntax
% =======
%
%     m = [m1,m2,...]
%
% Input arguments
% ================
%
% * `m1`, `m2` [ model ] - Compatible model objects that will be combined;
% the input models must be based on the same model file.
%
% Output arguments
% =================
%
% * `m` [ model ] - Output model object that combines the input model
% objects as multiple parameterisations.
%
% Description
% ============
%
% Example
% ========
%

% -IRIS Toolbox.
% -Copyright (c) 2007-2012 Jaromir Benes.

%**************************************************************************

if nargin == 1
    return
end

s = struct();
for i = 1 : numel(varargin)
    index = size(m.Assign,3) + (1 : size(varargin{1}.Assign,3));
    s.type = '()';
    s.subs = {index};
    m = subsasgn(m,s,varargin{1});
end

end